<?php
class SD_MAIL
{
	// クラス定数
	//const DEFERRED_WORK_DIR = '/var/www/myinc/dfdsdml';

	// プロテクト変数
	protected $nl = "\n";

	// パブリック変数
	public $DBCON;
	public $FROM, $FNAME, $TO, $TNAME, $CC, $CNAME, $BCC, $BNAME, $SUBJECT, $BODY;
	public $DEF = array(
		'FROM'    => 'info@alnethome.com',
		'FNAME'   => '',
		'TO'      => 'info@alnethome.com',
		'TNAME'   => '',
		'CC'      => '',
		'CNAME'   => '',
		'BCC'     => '',
		'BNAME'   => '',
		'SUBJECT' => 'NO TITLE',
		'BODY'    => 'NO BODY'
	);

	// コンストラクタ
	public function __construct( $DBCON = Null )
	{
		if( !is_null( $DBCON ) ) {
			$this->DBCON = $DBCON;
		}
	}
	// SENDMAIL
	public function Send() {
		if (!$this->TO) return;
		if ($this->FNAME) {
			$FromName = $this->EncHeader($this->FNAME, 'UTF-8');
			$mlfrom = $FromName.' <'.$this->FROM.'>';
		} else {
			$mlfrom = $this->FROM;
		}
		if ($this->TNAME) {
			$ToName = $this->EncHeader($this->TNAME, 'UTF-8');
			$mlto = $ToName.' <'.$this->TO.'>';
		} else {
			$mlto = $this->TO;
		}

		if (mb_strlen($this->SUBJECT) <= 0) {
			$this->SUBJECT = $this->DEF['SUBJECT'];
		}
		$mlsbj = $this->EncHeader($this->SUBJECT);

		if (mb_strlen($this->BODY) <= 0) {
			$this->BODY = $this->DEF['BODY'];
		}
		$mlbody = mb_convert_encoding($this->BODY, 'JIS');

		// メールの送信
		$mp = popen('/usr/sbin/sendmail -t', 'w');

		fputs($mp, 'From: '.$mlfrom.$this->nl);
		fputs($mp, 'To: '.$mlto.$this->nl);
		if ($this->CC) {
			fputs($mp, 'Cc: '.$this->CC.$this->nl);
		}
		if ($this->BCC) {
			fputs($mp, 'Bcc: '.$this->BCC.$this->nl);
		}
		fputs($mp, 'Subject: '.$mlsbj.$this->nl);
		fputs($mp, 'X-Mailer: Alnet Home Form Mail ver.1.0.0'.$this->nl);
		fputs($mp, 'Content-Type: text/plain; charset="ISO-2022-JP"'.$this->nl);
		fputs($mp, $this->nl);
		fputs($mp, $mlbody.$this->nl);

		pclose($mp);
	}
	protected function EncHeader($str, $enc = NULL) {
		if (!$enc) {
			$enc = mb_internal_encoding();
		}
		return '=?iso-2022-jp?B?'.base64_encode(mb_convert_encoding($str, 'JIS', $enc)).'?=';
	}
}
?>
