<?php
error_reporting( E_ALL & ~E_NOTICE );

if ( $_SERVER[ "REQUEST_METHOD" ] != "POST" ) {
	print "Access Error!!\n";
	exit;
}

include_once( "./define.class.php" );

include_once( FORM_COMMON_DIR . "/inc/session_handler.php" );
session_start();
$sesid = session_id();

include_once( FORM_COMMON_DIR . "/inc/form_pub.php" );

// セキュリティチェック(S):form_pub.php
$errflg = true;
$checkfld = array(
	//'showroom' => array( true, 'hankaku' ),
	'date' => array( true, 'numslash' ),
	'time' => array( true, 'time' ),
	'date2' => array( true, 'numslash' ),
	'time2' => array( true, 'time' ),
	'name' => array( true, 'hankaku' ),
	'namek' => array( true, 'hankaku' ),
	'tel' => array( true, 'numhaifun' ),
);
$errflg = Field_Security_Check( $checkfld );
if ( !$errflg ) {
	print "Access Error!!\n";
	exit;
}
// セキュリティチェック(E)

$_SESSION[ SECURITY_KEY_NAME ] = SECURITY_KEY;
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<title>
<?= FORM_TITLE1 . FORM_TITLE2 ?>
</title>
<meta name="description" content="<?= FORM_DESCRIPTION ?>"/>
<meta name="keywords" content="<?= FORM_KEYWORDS ?>"/>
<meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no">
<meta http-equiv="Last-Modified" content="<?= gmdate(" D, d M Y H:i:s ") ?> GMT">
<meta http-equiv="Cache-Control" content="no-store, no-cache,must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<link rel="SHORTCUT ICON" href="img/favicon.ico" />
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.5.0/css/all.css" integrity="sha384-B4dIYHKNBt8Bc12p+WXckhzcICo0wtJAoU8YZTY5qE0Id1GSseTk6S+L3BlXeVIU" crossorigin="anonymous">
<link rel="stylesheet" href="css/form_style.css?dm=<?= $mtime ?>" type="text/css" media="all"/>
</head>
<body>
<div id="fb-root"></div>
<script>
(function(d, s, id) {
	var js, fjs = d.getElementsByTagName(s)[0];
	if (d.getElementById(id)) return;
	js = d.createElement(s); js.id = id;
	js.src = "//connect.facebook.net/ja_JP/sdk.js#xfbml=1&version=v2.3&appId=498438413571467";
	fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));
</script>
<main class="main">
	<div class="container_f px-0">
		<header class="d-flex justify-content-center">
			<div class="title"><img src="img/logo2.png" alt="AlnetHome"></div>
			<strong class="s_title align-self-center"><b>出張相談のお問い合わせ</b></strong></header>
		<section>
			<ul class="formFlow mt-4">
				<li><span class="step">STEP.1</span> お客様情報の入力</li>
				<li class="cr"><span class="step">STEP.2</span> 内容確認</li>
				<li><span class="step">STEP.3</span> 送信完了</li>
			</ul>
			<p class="request-desc mb-4">入力された内容を今一度ご確認いただき、「送信する」ボタンをクリックしてお進みください。<br>
				入力内容を修正されたい方は、「修正する」ボタンをクリックしてください。</p>
			<div class="row cnf_btn">
				<div class="col px-2 text-center">
					<button type="button" class="btn btn-sm btn-gray prebtn" name="" id=""> <span class="align-middle"><img src="img/confirm-arrow-left.png" class="mr-2 d-inline-block"><strong class="align-middle">修正する</strong></span> </button>
				</div>
				<div class="col px-2 text-center">
					<button type="button" class="btn btn-sm btn-green_cnf nextbtn" name="" id=""> <span class="align-middle"><img src="img/confirm-arrow-new.png" class="mr-2 d-inline-block"><strong class="align-middle">送信する</strong></span> </button>
				</div>
			</div>
			<div class="thanks_privacy"> アルネットホームのフォームは、SSL通信による暗号化により、お客様の情報を保護しております。<br>
				<a href="/privacy/" target="_blank">「個人情報のお取扱いについて」</a> の内容をご確認・ご同意のうえ「送信する」ボタンへお進みください。 </div>
			<table class="table main_table table-bordered mb-3">
					<tr>
						<td class="hed bg-ok"><strong>これまでに当社でご記名されたことはございますか？</strong><span class="ok-label">OK</span></td>
						<td class="main bg-ok">
							<div class="form-row align-items-center">
								<div class="col-5 col-sm-5 mr-2">
<?php
	$yesno_ar = array(); $yesno_str = "";
	if( is_array( $_POST['yesno_kimei'] ) ) {
		if( count( $_POST['yesno_kimei'] ) > 0 ) {
			foreach( $_POST['yesno_kimei'] as $v ) {
				if( strlen( $v ) > 0 ) {
					$yesno_ar[] = "<div class=\"col-5 col-sm-5 mr-2\">{$v}</div>\n";
				}
			}
		}
	}
	if( count( $yesno_ar ) > 0 ) {
		$yesno_str = implode( PHP_EOL, $yesno_ar );
	}
	if( strlen( $yesno_str ) > 0 ) {
		print "{$yesno_str}\n";
	}
?>
								</div>
							</div>
						</td>
					</tr>
					<tr>
						<td class="hed bg-ok"><strong>当社の担当とご相談中ですか？</strong><span class="ok-label">OK</span></td>
						<td class="main bg-ok">
							<div class="form-row align-items-center">
								<div class="col-5 col-sm-5 mr-2">
<?php
	$yesno_ar = array(); $yesno_str = "";
	if( is_array( $_POST['yesno_soudan'] ) ) {
		if( count( $_POST['yesno_soudan'] ) > 0 ) {
			foreach( $_POST['yesno_soudan'] as $v ) {
				if( strlen( $v ) > 0 ) {
					$yesno_ar[] = "<div class=\"col-5 col-sm-5 mr-2\">{$v}</div>\n";
				}
			}
		}
	}
	if( count( $yesno_ar ) > 0 ) {
		$yesno_str = implode( PHP_EOL, $yesno_ar );
	}
	if( strlen( $yesno_str ) > 0 ) {
		print "{$yesno_str}\n";
	}
?>
								</div>
							</div>
						</td>
					</tr>
				<tr>
					<td class="hed bg-ok text-nowrap"><strong>ご希望日時</strong><span class="ok-label">OK</span></td>
					<td class="main bg-ok">
						<div class="form-row align-items-center mb-3">
							<div class="col col-sm-5"> <span class="col-form-label col-form-label-sm small d-block">第一希望</span>
								<?= $_POST['date'] ?>
							</div>
							<div class="col col-sm-4"> <span class="col-form-label col-form-label-sm small d-block">時間</span>
								<?= $_POST['time'] ?>
							</div>
							
							<div class="col col-sm-5"> <span class="col-form-label col-form-label-sm small d-block">第二希望</span>
								<?= $_POST['date2'] ?>
							</div>
							<div class="col col-sm-4"> <span class="col-form-label col-form-label-sm small d-block">時間</span>
								<?= $_POST['time2'] ?>
							</div>
						</div>
					</td>
				</tr>
				<tr>
					<td class="hed bg-ok text-nowrap"><strong>お名前（姓　名）</strong><span class="ok-label">OK</span></td>
					<td class="main bg-ok">
						<?= $_POST['name'] ?>
					</td>
				</tr>
				<tr>
					<td class="hed bg-ok text-nowrap"><strong>ふりがな（せい　めい）</strong><span class="ok-label">OK</span></td>
					<td class="main bg-ok">
						<?= $_POST['namek'] ?>
					</td>
				</tr>
				<tr>
					<td class="hed bg-ok text-nowrap"><strong>メールアドレス</strong><span class="ok-label">OK</span></td>
					<td class="main bg-ok">
						<?= $_POST['mail'] ?>
					</td>
				</tr>
				<tr>
					<td class="hed bg-ok text-nowrap"><strong>電話番号</strong><span class="ok-label">OK</span></td>
					<td class="main bg-ok">
						<?= $_POST['tel'] ?>
					</td>
				</tr>
				<tr>
					<td class="hed bg-ok"><strong>住所</strong><span class="ok-label">OK</span></td>
					<td class="main bg-ok"> <span class="col-form-label col-form-label-sm small d-block">郵便番号</span>
						<?= $_POST['zip'] ?>
						<br>
						<?= $_POST['add1'] ?>
						<br>
						<?= $_POST['add2'] ?>
					</td>
				</tr>
				<tr>
					<td class="hed bg-ok text-nowrap">ご相談内容<br class="pc_only">
						（複数回答可）</strong><span class="ok-label">OK</span></td>
					<td class="main bg-ok position-relative">
						<div class="form-row align-items-center">
							<?php
							$mokuteki_ar1 = array();
							$mokuteki_str1 = "";
							$mokuteki_ar2 = array();
							$mokuteki_str2 = "";
							if ( is_array( $_POST[ 'mokuteki' ] ) ) {
								if ( count( $_POST[ 'mokuteki' ] ) > 0 ) {
									foreach ( $_POST[ 'mokuteki' ] as $v ) {
										$sonota = "";
										if ( strlen( $v ) > 0 ) {
											if ( $v == "その他" && strlen( $_POST[ 'mokuteki_hoka' ] ) > 0 ) {
												$sonota = "：{$_POST['mokuteki_hoka']}";
											}
											$mokuteki_ar1[] = "<div class=\"col-12 col-sm-12 mr-2\">{$v}{$sonota}</div>\n";
											$mokuteki_ar2[] = $v;
										}
									}
								}
							}
							if ( count( $mokuteki_ar1 ) > 0 ) {
								$mokuteki_str1 = implode( PHP_EOL, $mokuteki_ar1 );
							}
							if ( count( $mokuteki_ar2 ) > 0 ) {
								$mokuteki_str2 = implode( ",", $mokuteki_ar2 );
							}
							if ( strlen( $mokuteki_str1 ) > 0 ) {
								print "{$mokuteki_str1}\n";
							}
							?>
						</div>
					</td>
				</tr>
				<tr>
					<td class="hed_off"><strong>ご質問・ご要望</strong><span class="option-label">任意</span></td>
					<td class="main_off">
						<?= nl2br( $_POST['iken'] ) ?>
					</td>
				</tr>
			</table>
			<div class="row cnf_btn">
				<div class="col px-2 text-center">
					<button type="button" class="btn btn-sm btn-gray prebtn" name="" id=""> <span class="align-middle"><img src="img/confirm-arrow-left.png" class="mr-2 d-inline-block"><strong class="align-middle">修正する</strong></span> </button>
				</div>
				<div class="col px-2 text-center">
					<button type="button" class="btn btn-sm btn-green_cnf nextbtn" name="" id=""> <span class="align-middle"><img src="img/confirm-arrow-new.png" class="mr-2 d-inline-block"><strong class="align-middle">送信する</strong></span> </button>
				</div>
			</div>
			<div class="thanks_privacy"> アルネットホームのフォームは、SSL通信による暗号化により、お客様の情報を保護しております。<br>
				<a href="/privacy/" target="_blank">「個人情報のお取扱いについて」</a> の内容をご確認・ご同意のうえ「送信する」ボタンへお進みください。 </div>
		</section>
	</div>
	<form action="thanks.php" method="post" name="fm01" id="fm01">
		<input type="hidden" name="yesno_kimei" value="<?= $_POST['yesno_kimei'] ?>">
		<input type="hidden" name="yesno_soudan" value="<?= $_POST['yesno_soudan'] ?>">
		<input type="hidden" name="date" value="<?= $_POST['date'] ?>">
		<input type="hidden" name="time" value="<?= $_POST['time'] ?>">
		<input type="hidden" name="date2" value="<?= $_POST['date2'] ?>">
		<input type="hidden" name="time2" value="<?= $_POST['time2'] ?>">
		<input type="hidden" name="name" value="<?= $_POST['name'] ?>">
		<input type="hidden" name="namek" value="<?= $_POST['namek'] ?>">
		<input type="hidden" name="mail" value="<?= $_POST['mail'] ?>">
		<input type="hidden" name="tel" value="<?= $_POST['tel'] ?>">
		<input type="hidden" name="zip" value="<?= $_POST['zip'] ?>">
		<input type="hidden" name="add1" value="<?= $_POST['add1'] ?>">
		<input type="hidden" name="add2" value="<?= $_POST['add2'] ?>">
		<input type="hidden" name="mokuteki" value="<?= $mokuteki_str2 ?>">
		<input type="hidden" name="mokuteki_hoka" value="<?= $_POST['mokuteki_hoka'] ?>">
		<input type="hidden" name="iken" value="<?= $_POST['iken'] ?>">
	</form>
	<form action="./" method="post" name="prefm" id="prefm">
		<input type="hidden" name="returnstr" value="1">
		<input type="hidden" name="yesno_kimei" value="<?= $_POST['yesno_kimei'] ?>">
		<input type="hidden" name="yesno_soudan" value="<?= $_POST['yesno_soudan'] ?>">
		<input type="hidden" name="date" value="<?= $_POST['date'] ?>">
		<input type="hidden" name="time" value="<?= $_POST['time'] ?>">
		<input type="hidden" name="date2" value="<?= $_POST['date2'] ?>">
		<input type="hidden" name="time2" value="<?= $_POST['time2'] ?>">
		<input type="hidden" name="name" value="<?= $_POST['name'] ?>">
		<input type="hidden" name="namek" value="<?= $_POST['namek'] ?>">
		<input type="hidden" name="mail" value="<?= $_POST['mail'] ?>">
		<input type="hidden" name="tel" value="<?= $_POST['tel'] ?>">
		<input type="hidden" name="zip" value="<?= $_POST['zip'] ?>">
		<input type="hidden" name="add1" value="<?= $_POST['add1'] ?>">
		<input type="hidden" name="add2" value="<?= $_POST['add2'] ?>">
		<?php
		if ( is_array( $_POST[ 'mokuteki' ] ) ) {
			if ( count( $_POST[ 'mokuteki' ] ) > 0 ) {
				foreach ( $_POST[ 'mokuteki' ] as $v ) {
					if ( strlen( $v ) > 0 ) {
						?>
		<input type="hidden" name="mokuteki[]" value="<?= $v ?>">
		<?php
		}
		}
		}
		}
		?>
		<input type="hidden" name="mokuteki_hoka" value="<?= $_POST['mokuteki_hoka'] ?>">
		<input type="hidden" name="iken" value="<?= $_POST['iken'] ?>">
	</form>
	<footer>
		<div class="d-flex flex-wrap">
			<div class="ft_logo align-self-center mr-auto"><img src="img/footer_logo.png" alt="アルネットホーム"></div>
			<div class="caption mr-auto align-self-center flex-fill">埼玉県・群馬県・栃木県・茨城県の注文住宅 [アルネットホーム]<br>
				Copyright© <?php echo date('Y'); ?> Alnet Home. All Rights Reserved.</div>
			<div class="tel align-self-center"> <img src="img/tel.png" alt="0120-221-644" class="align-middle mr-2 mb-2">0120-221-644 </div>
			<div class="info align-self-center text-right">受付時間 9:00〜18:00<br>
				定休日：毎週水曜日 月二回木曜日</div>
			<div class="tab-sp-only text-right small w-100 mt-3">© <?php echo date('Y'); ?> Alnet Home. All Rights Reserved</div>
		</div>
		<div class="footer-copy sp_only"><small><span>&copy;</span> <?php echo date('Y'); ?> Alnet Home. All Rights Reserved</small></div>
	</footer>
</main>

<!--151130追加タグ--> 
<!-- Google Tag Manager -->
<noscript>
<iframe src="//www.googletagmanager.com/ns.html?id=GTM-NSQMNV"
height="0" width="0" style="display:none;visibility:hidden"></iframe>
</noscript>
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'//www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-NSQMNV');</script> 
<!-- End Google Tag Manager --> 

<!-- Yahoo Tag Manager --> 
<script type="text/javascript">
  (function () {
    var tagjs = document.createElement("script");
    var s = document.getElementsByTagName("script")[0];
    tagjs.async = true;
    tagjs.src = "//s.yjtag.jp/tag.js#site=UZQdKwM";
    s.parentNode.insertBefore(tagjs, s);
  }());
</script>
<noscript>
<iframe src="//b.yjtag.jp/iframe?c=UZQdKwM" width="1" height="1" frameborder="0" scrolling="no" marginheight="0" marginwidth="0"></iframe>
</noscript>
<!-- End Yahoo Tag Manager --> 
<!--/151130追加タグ--> 

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script> 
<script src="https://code.jquery.com/jquery-migrate-3.0.0.min.js"></script> 
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js" integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo" crossorigin="anonymous"></script> 
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js" integrity="sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6" crossorigin="anonymous"></script>
<link rel="stylesheet" href="js/validationEngine_jq3/validationEngine.jquery.css" type="text/css"/>
<script src="js/validationEngine_jq3/jquery.validationEngine-ja.js" type="text/javascript" charset="utf-8"></script> 
<script src="js/validationEngine_jq3/jquery.validationEngine.js" type="text/javascript" charset="utf-8"></script> 
<script type="text/javascript" src="https://ajaxzip3.github.io/ajaxzip3.js"></script> 
<script type="text/javascript" src="js/script.js"></script> 
<script type="text/javascript">
$(function(){
	$('.nextbtn').on('click',function(){
		$('#fm01').submit();
	});
	$('.prebtn').on('click',function(){
		$('#prefm').submit();
		//history.back(0);
		//return false;
	});
});
</script>
</body>
</html>
